<!-- Main content -->
<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuOpen>{{ $data['menuOpen'] }} </x-slot:menuOpen>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.min.css">
    </x-slot:head>


    <section class="content">

        <!-- Default box -->
        <div class="row">
            <div class="col-lg-12">
                <x-message></x-message>
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <button class="btn btn-primary float-right" data-toggle="modal" data-target="#tambah"><i
                                class="fa fa-plus-circle mr-2"></i>
                            Item
                            Baru</button>
                        <h3 class="card-title"><i class="fa fa-server text-primary"></i> {{ $data['page'] }}</h3>
                    </div>
                    <div class="card-body">
                        <form class="form-inline float-right">
                            <input class="form-control mr-sm-2" type="search" placeholder="Search" aria-label="Search"
                                name="cari">
                            <button class="btn btn-primary " type="submit"> <i class="fa fa-search mr-2"></i>
                                Cari!</button>
                        </form>


                        <button class="btn btn-default shadow-sm">
                            <div class="icheck-blue d-inline " style="margin-right: -7px">
                                <input type="checkbox" id="cekall">
                                <label for="cekall">
                                </label>
                            </div>
                        </button>
                        <button class="btn btn-danger" id="pilih_hapus"><i class="fa fa-trash"></i> Hapus</button>
                        <table class="table table-bordered table-hover myTable tab mt-2">
                            <thead>
                                <tr>
                                    <th width="2%">No</th>
                                    <th width="5%">#</th>
                                    <th width="5%">#</th>
                                    <th>Kode Item</th>
                                    <th>Nama Item</th>
                                    <th>Stok</th>
                                    <th>Ditukar</th>
                                    <th>Poin Penukaran</th>
                                    <th>Tgl. Input</th>
                                    <th width="20%">Opsi</th>
                                </tr>
                            </thead>
                            <tbody id="view">
                                @forelse ($hadiah as $h)
                                    <tr>
                                        <td class="text-center">{{ $no++ }}</td>
                                        <td class="text-center">
                                            <div class="icheck-blue d-inline " style="margin-right: -7px">
                                                <input type="checkbox" name="id[]" id="cek{{ $h->id }}"
                                                    class="ceklis" value="{{ $h->id }}">
                                                <label for="cek{{ $h->id }}">
                                                </label>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <img alt="Avatar" class="table-avatar"
                                                src="{{ asset('/storage/produk/' . $h->gambar) }}" width="40px">
                                        </td>
                                        <td>{{ $h->kd_hadiah }}</td>
                                        <td>{{ $h->nm_hadiah }}</td>
                                        <td class="text-center"> {{ $h->stok - stok_item($h->kd_hadiah) }}
                                        </td>
                                        <td class="text-center">{{ stok_item($h->kd_hadiah) }}</td>
                                        <td class="text-center">{{ $h->poin }}</td>
                                        <td>{{ tgl_inf($h->created_at) }} </td>
                                        <td class="text-center">
                                            <button class="btn btn-sm btn-primary" data-toggle="modal"
                                                data-target="#edit{{ $h->id }}"><i class="fa fa-edit mr-2"></i>
                                                Edit</button>
                                            <button class="btn btn-sm btn-danger hapus" data-nm="{{ $h->nm_hadiah }}"
                                                data-id="{{ $h->id }}"><i class="fa fa-trash mr-2"></i>
                                                Hapus</button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="10" class="text-center">Data masih kosong</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                        {{ $hadiah->links('components.admin.pagination') }}
                    </div>
                </div>
            </div>


        </div>
        <!-- /.card -->

    </section>

    {{-- tambah --}}
    <div class="modal fade" id="tambah">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header bg-primary ">
                    Tambah Item Hadiah Baru
                </div>
                <form action="{{ route('hadiah-point.store') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">

                        <div class="form-group">
                            <label>Kode Item</label>
                            <input type="text" name="kd_hadiah" class="form-control" placeholder="Kode Item"
                                autofocus required value="{{ old('kd_hadiah') }}">
                            @error('kd_hadiah')
                                <small class="text-danger mt-2">
                                    {{ $message }}
                                </small>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label>Nama Item</label>
                            <input type="text" name="nm_hadiah" class="form-control" placeholder="Nama Item" required
                                value="{{ old('nm_hadiah') }}">
                        </div>

                        <div class="row">
                            <div class="col-md-6">

                                <div class="form-group">
                                    <label>Stok Item</label>
                                    <input type="text" name="stok" class="form-control numbers"
                                        placeholder="0 Item" required value="{{ old('stok') }}">
                                </div>

                            </div>

                            <div class="col-md-6">

                                <div class="form-group">
                                    <label>Poin Penukaran</label>
                                    <input type="text" name="poin" class="form-control numbers"
                                        placeholder="0 Poin" required value="{{ old('poin') }}">

                                </div>

                            </div>

                        </div>

                        <div class="form-group">
                            <label>Deskripsi</label>
                            <textarea name="keterangan" id="" class="form-control" required>{{ old('keterangan') }}</textarea>
                        </div>

                        <div class="form-group">
                            <label>Gambar </label>
                            <div class="custom-file">
                                <input type="file" name="gambar" class="custom-file-input exampleInputFile"
                                    id="exampleInputFile">
                                <label class="custom-file-label" for="exampleInputFile">Cari
                                    file</label>
                                @error('gambar')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>
                            <br>
                            <br>

                        </div>
                        <div class="d-flex justify-content-center">
                            <div style="height: 180px; width: 40%; border:1px solid  #eaedf0" class="gambar"></div>
                        </div>

                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary"><i class="fa fa-save mr-2"></i>Simpan</button>
                    </div>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    @foreach ($hadiah as $h)
        <div class="modal fade" id="edit{{ $h->id }}">
            <div class="modal-dialog ">
                <div class="modal-content">
                    <div class="modal-header bg-primary ">
                        Edit Item Hadiah
                    </div>
                    <form action="{{ route('hadiah-point.update') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        @method('put')
                        <div class="modal-body">
                            <input type="hidden" name="id" value="{{ $h->id }}">
                            <input type="hidden" name="kdlama" value="{{ $h->kd_hadiah }}">
                            <input type="hidden" name="gbrlama" value="{{ $h->gambar }}">

                            <div class="form-group">
                                <label>Kode Item</label>
                                <input type="text" name="kd_hadiah" class="form-control" placeholder="Kode Item"
                                    autofocus required value="{{ $h->kd_hadiah }}">
                                @error('kd_hadiah')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label>Nama Item</label>
                                <input type="text" name="nm_hadiah" class="form-control" placeholder="Nama Item"
                                    required value="{{ $h->nm_hadiah }}">
                            </div>

                            <div class="row">
                                <div class="col-md-6">

                                    <div class="form-group">
                                        <label>Stok Item</label>
                                        <input type="text" name="stok" class="form-control numbers"
                                            placeholder="0 Item" required value="{{ $h->stok }}">
                                    </div>

                                </div>

                                <div class="col-md-6">

                                    <div class="form-group">
                                        <label>Poin Penukaran</label>
                                        <input type="text" name="poin" class="form-control numbers"
                                            placeholder="0 Poin" required value="{{ $h->poin }}">

                                    </div>

                                </div>

                            </div>

                            <div class="form-group">
                                <label>Deskripsi</label>
                                <textarea name="keterangan" id="" class="form-control" required>{{ $h->keterangan }}</textarea>
                            </div>

                            <div class="form-group">
                                <label>Gambar </label>
                                <div class="custom-file">
                                    <input type="file" name="gambar" data-id="{{ $h->id }}"
                                        class="custom-file-input exampleInputFile" id="exampleInputFile">
                                    <label class="custom-file-label" for="exampleInputFile">Cari
                                        file</label>
                                    @error('gambar')
                                        <small class="text-danger mt-2">
                                            {{ $message }}
                                        </small>
                                    @enderror
                                </div>
                                <br>
                                <br>

                            </div>
                            <div class="d-flex justify-content-center">
                                <div style="height: 180px; width: 40%; border:1px solid  #eaedf0" class="gambar">
                                    <img alt="Avatar" class="table-avatar"
                                        src="{{ asset('/storage/produk/' . $h->gambar) }}" width="100%"
                                        id="img{{ $h->id }}">
                                </div>
                            </div>

                        </div>
                        <div class="modal-footer justify-content-between">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary"><i class="fa fa-save mr-2"></i>Edit
                                Item</button>
                        </div>
                    </form>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
    @endforeach

    <x-slot:foot>
        <script src="{{ asset('assets/') }}/admin/plugins/bs-custom-file-input/bs-custom-file-input.min.js"></script>

        <script src="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script>
            bsCustomFileInput.init();

            $(".exampleInputFile").change(function() {
                var id = $(this).attr('data-id')
                filePreview(this, id);
            });

            function filePreview(input, id) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $('#img').remove();
                        $('#img' + id).remove();
                        $('.gambar').append('<img src="' + e.target.result +
                            '" width="100%" height="180px" id="img' + id + '">');
                    };
                    reader.readAsDataURL(input.files[0]);
                }
            }


            $('#view').on('click', '.hapus', function() {
                var id = $(this).attr('data-id');
                var nama = $(this).attr('data-nm');

                Swal.fire({
                    title: "Apa anda yakin?",
                    text: "Item  dengan Nama ( " + nama + " ) akan di hapus!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Ya, Hapus!"
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.location.href = "delete-hadiah/" + id;
                    }
                });

            });

            $("#cekall").change(function() {
                if ($(this).prop("checked")) {
                    $(".ceklis").prop("checked", true);
                } else {
                    $(".ceklis").prop("checked", false);
                }
            });

            $("#pilih_hapus").click(function() {
                var allVals = [];
                $(".ceklis:checked").each(function() {
                    allVals.push($(this).val());
                });
                var token = $("meta[name='csrf-token']").attr("content");

                if (allVals.length <= 0) {
                    Toast.fire({
                        icon: "error",
                        title: "Ceklis data yang akan dihapus!!!.",
                    });
                } else {
                    Swal.fire({
                        title: "Pastikan dengan benar!",
                        text: "Data yang anda pilih akan dihapus!",
                        icon: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#3085d6",
                        cancelButtonColor: "#d33",
                        confirmButtonText: "Ya, Hapus!",
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                type: "DELETE",
                                url: "deleteall-hadiah",
                                data: {
                                    allVals: allVals,
                                    _token: token,
                                },
                                beforeSend: function() {
                                    $("#pilih_hapus").html(
                                        '<i class="fas fa-spinner fa-spin"></i> Tunggu..'
                                    );
                                    $("#pilih_hapus").attr("disabled", true);
                                },
                                success: function(data) {
                                    // alert(data)
                                    $("#pilih_hapus").html(
                                        '<i class="fa fa-trash"></i>'
                                    );
                                    $("#pilih_hapus").attr("disabled", true);
                                    Swal.fire({
                                        icon: "success",
                                        title: "Berhasil",
                                        text: "Data berhasil dihapus!",
                                    }).then((result) => {
                                        if (result.isConfirmed) {
                                            document.location.href = "";
                                        }
                                    });
                                },
                            });
                        }
                    });
                }
            });
        </script>
    </x-slot:foot>
</x-admin.contents>
